# Load state data
dirpath="e:/research/SyntheticControl/Empirical/Data/StateData/"
pop              = as.matrix(read.csv(paste0(dirpath,"Resident Population.csv")))
white            = as.matrix(read.csv(paste0(dirpath,"White.csv")))
age65            = as.matrix(read.csv(paste0(dirpath,"65+.csv")))
land             = as.matrix(read.csv(paste0(dirpath,"land area.csv")))
popdensity       = as.matrix(read.csv(paste0(dirpath,"density.csv")))
poverty          = as.matrix(read.csv(paste0(dirpath,"poverty.csv")))
personal_income  = as.matrix(read.csv(paste0(dirpath,"Annual Personal income per capita_Seasonal adjusted.csv")))
household_income = as.matrix(read.csv(paste0(dirpath,"Real Median Household Income.csv")))
nonfarm          = as.matrix(read.csv(paste0(dirpath,"Nonfarm_annual Seasonal adjusted.csv")))
Newhouse         = as.matrix(read.csv(paste0(dirpath,"Annual new house building permits.csv")))
                           

# Generate a table for state comparison
report=matrix(0, ncol = 49, nrow = 10)
rownames(report)=c("Resident population", 
                   "White alone, percentage", 
                   "65 years old and over, percentage", 
                   "Land area", 
                   "Population per square mile", 
                   "Person below poverty level, percentage", 
                   "Personal income per capita", 
                   "Real median household income", 
                   "Annual nonfarm",  
                   "New private housing units authorized by buliding permits")

colnames(report)=c("Alabama", "Arizona", "Arkansas", "California", "Colorado", 
                   "Connecticut", "Delaware", "District of Columbia", "Florida", "Georgia", 
                    "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", 
                    "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", 
                    "Michigan", "Minnesota", "Mississippi", "Missouri", "Montana", 
                    "Nebraska", "Nevada", "New Hampshire", "New Jersey", "New Mexico", 
                    "New York", "North Carolina", "North Dakota", "Ohio", "Oklahoma", 
                    "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "South Dakota", 
                    "Tennessee", "Texas", "Utah", "Vermont", "Virginia", 
                    "Washington", "West Virginia", "Wisconsin", "Wyoming")

########## Average States profile ##########
table=function(year){
    if(year < 1990){
        return("input must be between 1991 and 2017")
    }else if(year > 2017){
        return("input must be between 1991 and 2017")
    }else{
        for(i in 1:49){
            #Resident population
            report[1,i]=mean(pop[1:(year-1989),i+1], na.rm = TRUE)
            #White alone, percentage
            report[2,i]=mean(white[1:(year-1989),i+1], na.rm = TRUE)
            #65 years old and over, percentage
            report[3,i]=mean(age65[1:(year-1989),i+1], na.rm = TRUE)
            #Land area
            report[4,i]=land[i]
            #Population per square mile
            report[5,i]=mean(popdensity[1:(year-1989),i+1], na.rm = TRUE)
            #Person below poverty level, percentage
            report[6,i]=mean(poverty[1:(year-1989),i+1], na.rm = TRUE)
            #Personal income per capita
            report[7,i]=mean(personal_income[1:(year-1989),i+1], na.rm = TRUE)
            #Real median household income
            report[8,i]=mean(household_income[1:(year-1989),i+1], na.rm = TRUE)
            #Annual nonfarm
            report[9,i]=mean(nonfarm[1:(year-1989),i+1], na.rm = TRUE)
            #New private housing units authorized by buliding permits
            report[10,i]=mean(Newhouse[1:(year-1989),i+1], na.rm = TRUE)
        }
        name=paste0(dirpath,"/US_state_comparison", year, ".csv")
        write.csv(report,name)}
    return(report)}


table(1996)  # generate average state statistics before 1997
table(1998)  # generate average state statistics before 1998
table(2004)  # generate average state statistics before 2004